//=============================================================================

/*:
 * @plugindesc タイトルロゴ表示プラグイン
 * @author LefTonbo
 *
 * @param Title Logo
 * @desc タイトルロゴ画像
 * @default
 * @require 1
 * @dir img/pictures/
 * @type file
 *
 * @help
 */

//=============================================================================

var Imported = Imported || {};
Imported.LP_TitleLogoPicture = true;

var LeftPlugin = LeftPlugin || {};

LeftPlugin.Parameters = PluginManager.parameters('LP_TitleLogoPicture');
LeftPlugin.Param = LeftPlugin.Param || {};

LeftPlugin.Param.TitleLogo = String(LeftPlugin.Parameters['Title Logo']);

//=============================================================================

(function() {

//=============================================================================
// ImageManager
//=============================================================================

ImageManager.loadTitleLogo = function(filename, hue) {
    return this.loadBitmap('img/pictures/', filename, hue, true);
};

//=============================================================================
// Scene_Title
//=============================================================================

Scene_Title.prototype.createForeground = function() {
  this._gameTitleSprite = new Sprite(ImageManager.loadTitleLogo(LeftPlugin.Param.TitleLogo));
  this.addChild(this._gameTitleSprite);
  if ($dataSystem.optDrawTitle) {
    this.drawGameTitle();
  }
  this.posLogoSprite(this._gameTitleSprite);
};

Scene_Title.prototype.posLogoSprite = function(sprite) {
  sprite.x = Graphics.width * 0.5;
  sprite.y = 160;
  sprite.anchor.x = 0.5;
  sprite.anchor.y = 0.5;
};

//=============================================================================

})();

// EOF